/*
 * Decompiled with CFR 0.152.
 */
package crystalspider.torchhit.config;

import java.util.List;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.common.ForgeConfigSpec;

public class TorchHitConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final CommonConfig COMMON = new CommonConfig(BUILDER);
    public static final ForgeConfigSpec SPEC = BUILDER.build();

    public static Integer getDirectHitDuration() {
        return (Integer)TorchHitConfig.COMMON.directHitDuration.get();
    }

    public static Integer getIndirectHitDuration() {
        return (Integer)TorchHitConfig.COMMON.indirectHitDuration.get();
    }

    public static List<? extends String> getIndirectHitToolList() {
        return (List)TorchHitConfig.COMMON.indirectHitToolList.get();
    }

    public static List<? extends String> getExtraTorchItems() {
        return (List)TorchHitConfig.COMMON.extraTorchItems.get();
    }

    public static List<? extends String> getExtraSoulTorchItems() {
        return (List)TorchHitConfig.COMMON.extraSoulTorchItems.get();
    }

    public static Boolean getVanillaTorchesEnabled() {
        return (Boolean)TorchHitConfig.COMMON.vanillaTorchesEnabled.get();
    }

    public static Boolean getAllowCandles() {
        return (Boolean)TorchHitConfig.COMMON.allowCandles.get();
    }

    public static Boolean getConsumeCandle() {
        return (Boolean)TorchHitConfig.COMMON.consumeCandle.get();
    }

    public static Boolean getConsumeTorch() {
        return (Boolean)TorchHitConfig.COMMON.consumeTorch.get();
    }

    public static Boolean getConsumeWithoutFire() {
        return (Boolean)TorchHitConfig.COMMON.consumeWithoutFire.get();
    }

    public static Boolean getConsumeWithIndirectHits() {
        return (Boolean)TorchHitConfig.COMMON.consumeWithIndirectHit.get();
    }

    public static Integer getFireChance() {
        return (Integer)TorchHitConfig.COMMON.fireChance.get();
    }

    public static Boolean getFireFromMobs() {
        return (Boolean)TorchHitConfig.COMMON.fireFromMobs.get();
    }

    public static class CommonConfig {
        private final ForgeConfigSpec.IntValue directHitDuration;
        private final ForgeConfigSpec.IntValue indirectHitDuration;
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> indirectHitToolList;
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> extraTorchItems;
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> extraSoulTorchItems;
        private final ForgeConfigSpec.BooleanValue vanillaTorchesEnabled;
        private final ForgeConfigSpec.ConfigValue<Boolean> allowCandles;
        private final ForgeConfigSpec.ConfigValue<Boolean> consumeCandle;
        private final ForgeConfigSpec.BooleanValue consumeTorch;
        private final ForgeConfigSpec.BooleanValue consumeWithoutFire;
        private final ForgeConfigSpec.BooleanValue consumeWithIndirectHit;
        private final ForgeConfigSpec.IntValue fireChance;
        private final ForgeConfigSpec.BooleanValue fireFromMobs;

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            int maxDuration = Enchantments.f_44981_.m_6586_() * 4;
            this.directHitDuration = builder.comment("Fire damage duration for direct (main hand) hits.").defineInRange("direct hit duration", 4, 1, maxDuration);
            this.indirectHitDuration = builder.comment("Fire damage duration for indirect (off hand + tool) hits.").defineInRange("indirect hit duration", 2, 1, maxDuration);
            this.indirectHitToolList = builder.comment(new String[]{"List of tools that allow for an indirect hit when a torch is being held in the off hand.", "Leave empty to disable indirect hits.", "Insert either item categories or specific item IDs."}).defineListAllowEmpty(List.of("indirect tools"), () -> List.of("sword", "axe", "pickaxe", "shovel", "hoe"), element -> element instanceof String && !((String)element).isBlank());
            this.extraTorchItems = builder.comment("List of item ids that should be considered as a Torch.").defineListAllowEmpty(List.of("extra torch items"), () -> List.of("bonetorch:bonetorch", "torchmaster:megatorch", "hardcore_torches:lit_torch", "magnumtorch:diamond_magnum_torch", "magnumtorch:emerald_magnum_torch", "magnumtorch:amethyst_magnum_torch", "magical_torches:mega_torch", "magical_torches:grand_torch", "magical_torches:medium_torch", "magical_torches:small_torch", "pgwbandedtorches:banded_torch_white", "pgwbandedtorches:banded_torch_orange", "pgwbandedtorches:banded_torch_magenta", "pgwbandedtorches:banded_torch_light_blue", "pgwbandedtorches:banded_torch_yellow", "pgwbandedtorches:banded_torch_lime", "pgwbandedtorches:banded_torch_pink", "pgwbandedtorches:banded_torch_gray", "pgwbandedtorches:banded_torch_light_gray", "pgwbandedtorches:banded_torch_cyan", "pgwbandedtorches:banded_torch_purple", "pgwbandedtorches:banded_torch_blue", "pgwbandedtorches:banded_torch_brown", "pgwbandedtorches:banded_torch_green", "pgwbandedtorches:banded_torch_red", "pgwbandedtorches:banded_torch_black"), element -> element instanceof String && !((String)element).isBlank());
            this.extraSoulTorchItems = builder.comment("List of item ids that should be considered as a Soul Torch.").defineListAllowEmpty(List.of("extra soul torch items"), () -> List.of("pgwbandedtorches:banded_soul_torch_white", "pgwbandedtorches:banded_soul_torch_orange", "pgwbandedtorches:banded_soul_torch_magenta", "pgwbandedtorches:banded_soul_torch_light_blue", "pgwbandedtorches:banded_soul_torch_yellow", "pgwbandedtorches:banded_soul_torch_lime", "pgwbandedtorches:banded_soul_torch_pink", "pgwbandedtorches:banded_soul_torch_gray", "pgwbandedtorches:banded_soul_torch_light_gray", "pgwbandedtorches:banded_soul_torch_cyan", "pgwbandedtorches:banded_soul_torch_purple", "pgwbandedtorches:banded_soul_torch_blue", "pgwbandedtorches:banded_soul_torch_brown", "pgwbandedtorches:banded_soul_torch_green", "pgwbandedtorches:banded_soul_torch_red", "pgwbandedtorches:banded_soul_torch_black"), element -> element instanceof String && !((String)element).isBlank());
            this.vanillaTorchesEnabled = builder.comment(new String[]{"Whether Vanilla torches can set targets on fire.", "If false, only the items specified by [extra torch items] and [extra soul torch items] will set targets on fire."}).define("vanilla torches enabled", true);
            this.allowCandles = builder.comment("Whether to allow candles to act as torches.").define("allow candles", true);
            this.consumeCandle = builder.comment(new String[]{"Whether candles should break upon use.", "Effective only if [allowCandles] is enabled."}).define("consume candle", true);
            this.consumeTorch = builder.comment("Whether torches should break upon use.").define("consume torch", false);
            this.consumeWithoutFire = builder.comment(new String[]{"Whether to break the torch/candle upon use even if no fire was set.", "Effective only if [fire chance] and at least one of [consume torch] and [consume candle] are set different from default."}).define("consume without fire", false);
            this.consumeWithIndirectHit = builder.comment(new String[]{"Whether to break the torch/candle upon indirect hits.", "Effective only if [consume torch] is set to true."}).define("consume with indirect hits", false);
            this.fireChance = builder.comment("Chance (in percentage) for torches/candles to set targets on fire.").defineInRange("fire chance", 100, 1, 100);
            this.fireFromMobs = builder.comment(new String[]{"Whether mobs wielding a torch can set their targets on fire.", "Generally useful only when other mods tweak mobs to wield torches."}).define("fire from mobs", true);
        }
    }
}

